
# Configuração do Google reCAPTCHA v2

## Passos para configurar:

### 1. Obter chaves do Google reCAPTCHA
1. Acesse: https://www.google.com/recaptcha/admin/create
2. Escolha reCAPTCHA v2 ("Não sou um robô")
3. Adicione seus domínios (ex: yourdomain.com, localhost)
4. Aceite os termos e clique em "Enviar"
5. Copie as chaves: **Site Key** e **Secret Key**

### 2. Substituir no código HTML
Substitua `YOUR_SITE_KEY_HERE` pela sua **Site Key** nos arquivos:
- `index.html` (linha do data-sitekey)
- `contato.html` (linha do data-sitekey)

### 3. Validação no Backend (Node.js)
```javascript
const express = require('express');
const fetch = require('node-fetch');
const app = express();

app.use(express.json());
app.use(express.urlencoded({ extended: true }));

// Substitua pela sua Secret Key
const RECAPTCHA_SECRET_KEY = 'YOUR_SECRET_KEY_HERE';

app.post('/contact', async (req, res) => {
    const { 'g-recaptcha-response': recaptchaToken } = req.body;
    
    if (!recaptchaToken) {
        return res.status(400).json({ error: 'reCAPTCHA é obrigatório' });
    }
    
    try {
        // Verificar reCAPTCHA
        const verifyResponse = await fetch('https://www.google.com/recaptcha/api/siteverify', {
            method: 'POST',
            headers: { 'Content-Type': 'application/x-www-form-urlencoded' },
            body: `secret=${RECAPTCHA_SECRET_KEY}&response=${recaptchaToken}`
        });
        
        const verifyData = await verifyResponse.json();
        
        if (!verifyData.success) {
            return res.status(400).json({ error: 'reCAPTCHA inválido' });
        }
        
        // Processar formulário aqui
        console.log('Formulário válido:', req.body);
        res.json({ success: true, message: 'Mensagem enviada com sucesso!' });
        
    } catch (error) {
        console.error('Erro na verificação:', error);
        res.status(500).json({ error: 'Erro interno do servidor' });
    }
});

app.listen(5000, () => {
    console.log('Servidor rodando na porta 5000');
});
```

### 4. Validação no Backend (PHP)
```php
<?php
// Substitua pela sua Secret Key
$secretKey = 'YOUR_SECRET_KEY_HERE';

if ($_POST['g-recaptcha-response']) {
    $recaptchaToken = $_POST['g-recaptcha-response'];
    
    // Verificar reCAPTCHA
    $verifyResponse = file_get_contents("https://www.google.com/recaptcha/api/siteverify?secret={$secretKey}&response={$recaptchaToken}");
    $responseData = json_decode($verifyResponse);
    
    if ($responseData->success) {
        // Processar formulário aqui
        echo json_encode(['success' => true, 'message' => 'Mensagem enviada com sucesso!']);
    } else {
        echo json_encode(['error' => 'reCAPTCHA inválido']);
    }
} else {
    echo json_encode(['error' => 'reCAPTCHA é obrigatório']);
}
?>
```

## Funcionalidades implementadas:
✅ reCAPTCHA v2 ("Não sou um robô")
✅ Validação no frontend (impede envio se não resolvido)
✅ Mensagens de erro em português
✅ Design responsivo (escala em mobile)
✅ Reset automático após envio
✅ Compatível com HTML puro (sem frameworks)
✅ Scroll automático para o reCAPTCHA em caso de erro
✅ Fallback caso o reCAPTCHA não carregue

## Domínios para teste:
- localhost (para desenvolvimento)
- 127.0.0.1 (para desenvolvimento)
- seu-dominio.replit.dev (para Replit)
